/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\arbowing.cpp,v 1.2 2002-08-29 12:17:28+02 renz Exp $ 

$Id: arbowing.cpp,v 1.2 2002-08-29 12:17:28+02 renz Exp $ 

$Log: arbowing.cpp,v $
Revision 1.2  2002-08-29 12:17:28+02  renz
Added RCS Headers
 

$Author: renz $ 

$Date: 2002-08-29 12:17:28+02 $ 

$Locker:  $ 

$Revision: 1.2 $ 

$Name:  $ 

$RCSfile: arbowing.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\arbowing.cpp,v $ 

*/
// ARBowing
#include "AbstrctR\AbstrctO\ARBowing.h"
#include "AbstrctR\AbstrctO\TgPrmtrF.h"
#include <math.h>

// Class ARBowing

/* ARBowing::ARBowing(ARNote* beginOfBowing, ARNote* endOfBowing)
  : begin(beginOfBowing),
	 end(endOfBowing)
{
	ASSERT(begin);
	ASSERT(end);
} */

ListOfTPLs ARBowing::ltpls(1);

ARBowing::ARBowing()
{
	rangesetting = ONLY;
	setAssociation(ARMusicalTag::RA);

	dx1 = dy1 = dx2 = dy2 = r3 = h = NULL;
	curve = NULL;

	parset = 0;
}

ARBowing::ARBowing(const ARBowing *bowing)
: ARMTParameter(-1,bowing)
{
	rangesetting = ONLY;
	setAssociation(ARMusicalTag::RA);

	dx1 = dy1 = dx2 = dy2 = r3 = h = NULL;
	curve = NULL;

	parset = 0;

	if (bowing->curve)
	{
		curve = dynamic_cast<TagParameterString *>(
			bowing->curve->getCopy());
	}
	if (bowing->dx1)
	{
		dx1 = dynamic_cast<TagParameterFloat *>(
			bowing->dx1->getCopy());
	}
	if (bowing->dy1)
	{
		dy1 = dynamic_cast<TagParameterFloat *>(
			bowing->dy1->getCopy());
	}
	if (bowing->dx2)
	{
		dx2 = dynamic_cast<TagParameterFloat *>(
			bowing->dx2->getCopy());
	}
	if (bowing->dy2)
	{
		dy2 = dynamic_cast<TagParameterFloat *>(
			bowing->dy2->getCopy());
	}
	if (bowing->r3)
	{
		r3 = dynamic_cast<TagParameterFloat *>(
			bowing->r3->getCopy());
	}
	if (bowing->h)
	{
		h = dynamic_cast<TagParameterFloat *>(
			bowing->h->getCopy());
	}


}

ARBowing::~ARBowing()
{
	if (dx1)
		delete dx1;
	if (dy1)
		delete dy1;
	if (dx2)
		delete dx2;
	if (dy2)
		delete dy2;
	if (r3)
		delete r3;
	if (h)
		delete h;
	if (curve)
		delete curve;
}



/* void ARBowing::setEnd(ARNote* endOfBowing)
{
	ASSERT(endOfBowing);
	end=endOfBowing;
}

void ARBowing::setBegin(ARNote* beginOfBowing)
{
	ASSERT(beginOfBowing);
	begin=beginOfBowing;
}

ARNote* ARBowing::getBegin()
{
	return begin;
}

ARNote* ARBowing::getEnd()
{
	return end;
}


*/

void ARBowing::print() const
{

}


void ARBowing::setTagParameterList(TagParameterList & tpl)
{
	if (ltpls.GetCount() == 0)
	{
		// \slur<dx1,dy1, dx2,dy2, r3,h> 
		ListOfStrings lstrs(1);
/*		// old compatability ...
		lstrs.AddTail(
			new NVstring("U,dy1,2hs,r"));
		lstrs.AddTail(
			new NVstring("U,dy1,2hs,r;U,dy2,2hs,r"));
		lstrs.AddTail(
			new NVstring("U,dy1,2hs,r;U,dy2,2hs,r;F,r3,0.5,r;U,dy3,1hs,r"));
			*/
		lstrs.AddTail(
			new NVstring("U,dx1,2hs,o;U,dy1,1hs,o;"
			             "U,dx2,-2hs,o;U,dy2,1hs,o;F,r3,0.5,o;U,h,2hs,o"));
		lstrs.AddTail(
			new NVstring("S,curve,down,o"));
		CreateListOfTPLs(ltpls,lstrs);
	}

	TagParameterList *rtpl = NULL;
	int ret = MatchListOfTPLsWithTPL(ltpls,tpl,&rtpl);

	if (ret>=0 && rtpl)
	{
		// we found a match!
		if (ret == 0)
		{
	/*		// this is old compatability ...
			parcount = 1;

			TagParameterFloat *tpf = 
				dynamic_cast<TagParameterFloat *>(rtpl->GetHead());
			ASSERT(tpf);
			dy1 = tpf->getValue();
			dy2 = dy1;
		}
		else if (ret == 1)
		{
			// old compatability 
			parcount = 2;

			POSITION pos = rtpl->GetHeadPosition();
			TagParameterFloat *tpf = 
				dynamic_cast<TagParameterFloat *>(rtpl->GetNext(pos));
			ASSERT(tpf);
			if (tpf->TagIsSet())
				dy1 = tpf->getValue();

			tpf = 
				dynamic_cast<TagParameterFloat *>(rtpl->GetNext(pos));
			ASSERT(tpf);
			if (tpf->TagIsSet())
				dy2 = tpf->getValue();


		}
		else if (ret == 2)
		{
			// old compatability 
			parcount = 4;

			hascontrol = 1;

			POSITION pos = rtpl->GetHeadPosition();
			TagParameterFloat *tpf = 
				dynamic_cast<TagParameterFloat *>(rtpl->GetNext(pos));
			ASSERT(tpf);
			dy1 = tpf->getValue();

			tpf = 
				dynamic_cast<TagParameterFloat *>(rtpl->GetNext(pos));
			ASSERT(tpf);
			dy2 = tpf->getValue();

			tpf = 
				dynamic_cast<TagParameterFloat *>(rtpl->GetNext(pos));
			ASSERT(tpf);
			dx3 = tpf->getValue();

			tpf = 
				dynamic_cast<TagParameterFloat *>(rtpl->GetNext(pos));
			ASSERT(tpf);
			dy3 = tpf->getValue();
			
		}
		else if (ret == 3)
		{ */

			dx1 =
				dynamic_cast<TagParameterFloat *>(rtpl->RemoveHead());
			ASSERT(dx1);
			if (dx1->TagIsSet())
				parset = 1;

			dy1 = dynamic_cast<TagParameterFloat *>(rtpl->RemoveHead());
			ASSERT(dy1);
			if (dy1->TagIsSet())
				parset = 1;
	
			dx2 = dynamic_cast<TagParameterFloat *>(rtpl->RemoveHead());
			ASSERT(dx2);
			if (dx2->TagIsSet())
				parset = 1;

			dy2 = dynamic_cast<TagParameterFloat *>(rtpl->RemoveHead());
			ASSERT(dy2);
			if (dy2->TagIsSet())
				parset = 1;

			r3 = dynamic_cast<TagParameterFloat *>(rtpl->RemoveHead());
			ASSERT(r3);
			if (r3->TagIsSet())
				parset = 1;

			h = dynamic_cast<TagParameterFloat *>(rtpl->RemoveHead());
			ASSERT(h);

			if (h->TagIsSet())
				parset = 1;
		}
		else if (ret==1)
		{
			// then, we have the "curve"-parameter ...
			// depending on upward or downward curve, we 
			// set the dx-parameters.
			curve = 
				dynamic_cast<TagParameterString *>(rtpl->RemoveHead());
			ASSERT(curve);
			if (curve->TagIsSet())
				parset = 1;

			if (curve->getValue() == NVstring("down"))
			{
				// we have a downward-curve
				dx1= new TagParameterFloat(1.2);
				dx1->setUnit("hs");
				
				dy1= new TagParameterFloat(-1.1);
				dy1->setUnit("hs");

				dx2= new TagParameterFloat(-1.2);
				dx2->setUnit("hs");

				dy2 = new TagParameterFloat(-1.1);
				dy2->setUnit("hs");

				r3 = new TagParameterFloat(0.5);

				h  = new TagParameterFloat(-2);
				h->setUnit("hs");
			}
			else
			{
				// we assume an upward curve ...
				dx1= new TagParameterFloat(1.2);
				dx1->setUnit("hs");
				
				dy1= new TagParameterFloat(1.1);
				dy1->setUnit("hs");

				dx2= new TagParameterFloat(-1.2);
				dx2->setUnit("hs");

				dy2 = new TagParameterFloat(1.1);
				dy2->setUnit("hs");

				r3 = new TagParameterFloat(0.5);

				h  = new TagParameterFloat(2);
				h->setUnit("hs");
				}

		}

		delete rtpl;

	}
	else
	{
		// failure
	}

	tpl.RemoveAll();
	return;

	/* parcount = tlist.GetCount();
	if (parcount < 1 && parcount > 2 && parcount!=4)
	{
		if (parcount==6)
		{ 
			// not supported yet
			WARNING("6 parameters fur slur not yet supported. Using no parameters");
		}
		else
			WARNING("not a valid number of parameters for slur. Parameters ignored");
		tlist.RemoveAll();
		parcount = 0; // just leave as is ...
		Reset();
		return;
	}

	// one parameter is "sure"
	TagParameter *tp = tlist.RemoveHead();
	if (dynamic_cast<TagParameterFloat*>(tp))
	{
		dy1 = dynamic_cast
			<TagParameterFloat*>(tp)->getValue();
	}
	else
	{
		// 
		WARNING("Not a valid type for slur-Parameter. Parameters ignored");
		delete tp;
		parcount = 0;
		tlist.RemoveAll();
		Reset();
		return;
	}

	
	delete tp;


	if (parcount == 1)
	{
		dy2 = dy1;
	}
	else // parcount == 2 || parcount == 4
	{
		TagParameter *tp = tlist.RemoveHead();
	
		if (dynamic_cast<TagParameterFloat*>(tp))
		{
			dy2 = dynamic_cast
				<TagParameterFloat*>(tp)->getValue();
		}
		else 
		{
			delete tp;
			WARNING("Not a valid second parameter type for slur-Tag. Parameters ignored");
			parcount = 0;
			tlist.RemoveAll();
			Reset();
			return;
		}

		delete tp;
	}

	if (parcount == 4)
	{

		// syntax: x is a float in the range
		// between 0.0 and 1.0
		// indication a relative Position between
		// the start and endpoint of the slur.

		// has control point ...
		hascontrol = 1;

		TagParameter *tp = tlist.RemoveHead();
		if (dynamic_cast<TagParameterFloat*>(tp))
		
		{
			dx3 = dynamic_cast
				<TagParameterFloat*>(tp)->getValue();
		}
		else
		{
			WARNING("not a valid parametertype for 3rd parameter in slur-Tag. Parameters ignored.");
			parcount = 0;
			tlist.RemoveAll();
			Reset();
			delete tp;
			return;
		}

		delete tp;

		tp = tlist.RemoveHead();
		if (dynamic_cast<TagParameterFloat*>(tp))
		
		{
			dy3 = dynamic_cast
				<TagParameterFloat*>(tp)->getValue();
		}
		else
		{
			WARNING("not a valid parametertype for 4th parameter in slur-Tag. Parameters ignored.");
			parcount = 0;
			tlist.RemoveAll();
			Reset();
			delete tp;
			return;
		}

		delete tp;

	} // parcount == 4

	*/
}


//void ARBowing::Reset()
//{
//	dy1 = 0.0;
//	dy2 = 0.0;
//	dx3 = 0.0;
//	dy3 = 0.0;
//	parcount = 0;
//	hascontrol = 0;
//}

void ARBowing::PrintParameters(ostream &os) const
{
	int previous = 0;
	if (parset)
	{
		os << "<";
	}
	if (curve && curve->TagIsSet())
	{
		os << "curve=\"" << curve->getValue() << "\"";
	}
	else
	{
		if (dx1 && dx1->TagIsSet())
		{
			os << "dx1=" << dx1->getUnitValue() << dx1->getUnit();
			previous = 1;
		}
		if (dy1 && dy1->TagIsSet())
		{
			if (previous)
				os << ",";
			os << "dy1=" << dy1->getUnitValue() << dy1->getUnit();
			previous = 1;
		}
		if (dx2 && dx2->TagIsSet())
		{
			if (previous)
				os << ",";
			os << "dx2=" << dx2->getUnitValue() << dx2->getUnit();
			previous = 1;
		}
		if (dy2 && dy2->TagIsSet())
		{
			if (previous)
				os << ",";
			os << "dy2=" << dy2->getUnitValue() << dy2->getUnit();
			previous = 1;
		}
		if (r3 && r3->TagIsSet())
		{
			if (previous)
				os << ",";
			os << "r3=" << r3->getUnitValue();
			previous = 1;
		}
		if (h && h->TagIsSet())
		{
			if (previous)
				os << ",";
			os << "h=" << h->getUnitValue() << h->getUnit();
			previous = 1;
		}
	}
	
	if (parset)
		os << ">";


}

TagParameterList *ARBowing::getTagParameterList() const
{
	TagParameterList *tpl = new TagParameterList(1);

	if (curve && curve->TagIsSet())
	{
		tpl->AddTail(curve->getCopy());
		return tpl;
	}

	// now we see, which parameters are set ....
	if (dx1 && dx1->TagIsSet())
	{
		tpl->AddTail(dx1->getCopy());
	}
	if (dy1 && dy1->TagIsSet())
	{
		tpl->AddTail(dy1->getCopy());
	}
	if (dx2 && dx2->TagIsSet())
	{
		tpl->AddTail(dx2->getCopy());
	}
	if (dy2 && dy2->TagIsSet())
	{
		tpl->AddTail(dy2->getCopy());
	}
	if (r3 && r3->TagIsSet())
	{
		tpl->AddTail(r3->getCopy());
	}
	if (h && h->TagIsSet())
	{
		tpl->AddTail(h->getCopy());
	}

	return tpl;
}

// this routine is called by Graphics to automatically
// set the curvature of slurs/ties.
// we should probably also use the begin- and end-point
// of the bow to determine optimum curvature ...
void ARBowing::setCurve(int curve,const NVPoint &p1, const NVPoint &p2)
{
	// this only works, if the parameters have NOT been set
	// by the user before-hand ...

	if (parset) return;

	// we take into account the distance for the curvature ...
	float distx = p2.x - p1.x;
	float disty = p2.y - p1.y;
	float alpha = atan2(disty,distx);
	float myr3 = (0.5 * distx) / cos(alpha) / distx;
	float myh = 1.5; // 2hs are standard
	if (alpha < -0.02 || alpha > 0.02)
	{
		if (alpha < 0)
		{
			alpha = -alpha;
		}


		myh = distx / 2 * tan(alpha) / LSPACE * 2;

		if (myh < 1.5)
			myh += 1.5;
	}

	if (distx < 151)
	{
		if (myh == 1.5)
			myh = 0.75;
	}

	if (curve == 1)
	{
		// upward
		if (dx1) delete dx1;
		dx1= new TagParameterFloat(1.2);
		dx1->setUnit("hs");
		
		if (dy1) delete dy1;
		dy1= new TagParameterFloat(1.1);
		dy1->setUnit("hs");
		
		if (dx2) delete dx2;
		dx2= new TagParameterFloat(-1.2);
		dx2->setUnit("hs");
		
		if (dy2) delete dy2;
		dy2 = new TagParameterFloat(1.1);
		dy2->setUnit("hs");
		
		if (r3) delete r3;
		r3 = new TagParameterFloat(myr3);
		
		if (h) delete h;
		h  = new TagParameterFloat(myh);
		h->setUnit("hs");
	}
	else if (curve == -1)
	{
		// downward
		// we have a downward-curve
		if (dx1) delete dx1;
		dx1= new TagParameterFloat(1.2);
		dx1->setUnit("hs");
		
		if (dy1) delete dy1;
		dy1= new TagParameterFloat(-1.1);
		dy1->setUnit("hs");
		
		if (dx2) delete dx2;
		dx2= new TagParameterFloat(-1.2);
		dx2->setUnit("hs");
		
		if (dy2) delete dy2;
		dy2 = new TagParameterFloat(-1.1);
		dy2->setUnit("hs");
		
		if (r3) delete r3;
		r3 = new TagParameterFloat(myr3);
		
		if (h) delete h;
		h  = new TagParameterFloat(-myh);
		h->setUnit("hs");
	}
}